---
title: 1xx Informational · Cloudflare Support docs
description: The 1xx Informational status codes serve as interim responses that
  provide connection status updates without completing the request-response
  cycle. These codes are not intended for final actions but rather to indicate
  that the request is being processed or additional steps are required.
lastUpdated: 2025-05-06T10:45:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/1xx-informational/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/1xx-informational/index.md
---

The 1xx Informational status codes serve as interim responses that provide connection status updates without completing the request-response cycle. These codes are not intended for final actions but rather to indicate that the request is being processed or additional steps are required.

The requirements the server must follow when sending 1xx Informational status codes in response to a client's request include:

* Responses must be terminated by the first empty line following the status line.
* 1xx responses are not supported by HTTP/1.0; the origin server should never send a 1xx response to an HTTP/1.0 client.

Cloudflare forwards all 1xx responses from origin servers but does not generate them directly.

## 100 Continue

The 100 Continue status indicates that the server has received the request headers and is ready for the client to send the request body. For more information, refer to [RFC 7231](https://tools.ietf.org/html/rfc7231).

### Common use cases

Allows clients to verify if the server will accept their request headers before sending a potentially large or unusable request body, optimizing data flow.

When a client includes the `Expect: 100-continue` header, it is requesting a confirmation before sending the request body, prompting the server to respond immediately with either `100 Continue` to proceed or an appropriate status code (for example, `401 Unauthorized` or `413 Payload Too Large`) if the request is unacceptable.

### Cloudflare-specific information

Cloudflare uses Keep-Alive connections to maintain persistent communication between clients and servers, making the `100 Continue` response typically unnecessary, as Keep-Alive reduces overhead and eliminates the need for intermediate confirmations.

## 101 Switching Protocols

The 101 Switching Protocols status code indicates that the origin server accepts the client's request to switch protocols. For more information, refer to [RFC 7231](https://tools.ietf.org/html/rfc7231).

### Common use cases

The 101 Switching Protocols status code indicates that the server has accepted the client's request to change protocols, either by including an `Upgrade` header or through a change in the application protocol on the connection. When the `Upgrade` header is used, the server agrees to switch to a protocol higher on the client's priority list and responds with an `Upgrade` header to specify the new protocol(s). This change is assumed to benefit both the client and the server, with WebSockets being the most common use case.

### Cloudflare-specific information

Cloudflare supports WebSocket connections, which often involve the 101 Switching Protocols status code. The protocol switch allows clients to establish a WebSocket connection for real-time, bidirectional communication. For information about Cloudflare's Websockets, refer to [Cloudflare Now Supports Websockets](https://blog.cloudflare.com/cloudflare-now-supports-websockets/).

## 102 Processing

102 Processing status code indicates that the server has received the request and is currently processing it, but the final response is not yet ready. This status code is only applicable to HTTP/1.1 and higher. For more information, refer to [RFC 2518](https://tools.ietf.org/html/rfc2518).

### Common use cases

The 102 Processing status code is commonly used in scenarios requiring long-running operations, such as complex database transactions or large file processing. It helps maintain the connection during extended processing times, typically exceeding 20 seconds, ensuring efficient communication between the client and server throughout the operation.

### Cloudflare-specific information

If Cloudflare receives a 102 Processing response, it expects a final response within 100 seconds. Failure to receive this response results in an [Error 522: Connection Timed Out](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-522/). However, sending interim 102 Processing responses can help prevent [Error 524: A timeout occurred](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-524/), ensuring that the connection remains active while the server processes the request.
