---
title: Page Rules migration guide · Cloudflare Rules docs
description: Cloudflare is continuously improving its platform to deliver more
  powerful and scalable tools for managing your configurations. To help you take
  full advantage of these improvements, we recommend using modern Rules features
  for new implementations. These products address the limitations of Page Rules
  while providing greater flexibility, scalability, and ease of use.
lastUpdated: 2025-09-15T16:47:39.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/reference/page-rules-migration/
  md: https://developers.cloudflare.com/rules/reference/page-rules-migration/index.md
---

Cloudflare is continuously improving its platform to deliver more powerful and scalable tools for managing your configurations. To help you take full advantage of these improvements, we recommend using [modern Rules features](https://developers.cloudflare.com/rules/) for new implementations. These products address the limitations of Page Rules while providing greater flexibility, scalability, and ease of use.

For a quick start, explore the one-click templates available in the Cloudflare dashboard in **Rules** > **Overview**. These templates simplify common configurations like redirects, rewrites and header modifications, making setup faster and easier.

## Page Rules migration

To make the transition seamless, Cloudflare will handle the migration of your existing Page Rules automatically. This process is planned for late 2025 or beyond, with no action required on your part. You will receive advance notification before any changes are made.

If you wish to explore the benefits of modern Rules features sooner, you can begin adopting them today. Doing so allows you to:

* Take advantage of modern features and capabilities sooner.
* Customize and refine your rules to match your evolving needs.

To assist with this process, we provide you with a comprehensive mapping between Page Rules settings and modern Rules products in this guide.

## Why transition?

Cloudflare Page Rules has several fundamental limitations, such as triggering solely based on URL patterns and being limited to 125 rules per zone for performance reasons. These rules are also complex to debug when multiple page rules apply to the same incoming request.

In 2022, we announced in our blog post [The future of Page Rules](https://blog.cloudflare.com/future-of-page-rules) that Page Rules would be replaced with a suite of dedicated products, each built to be best-of-breed and put more power into the hands of our users. The new Rules products — [Configuration Rules](https://developers.cloudflare.com/rules/configuration-rules/), [Compression Rules](https://developers.cloudflare.com/rules/compression-rules/), [Origin Rules](https://developers.cloudflare.com/rules/origin-rules/), [Redirects](https://developers.cloudflare.com/rules/url-forwarding/), and [Transform Rules](https://developers.cloudflare.com/rules/transform/) — are now generally available (GA) and have already been adopted by tens of thousands of Cloudflare customers.

Improvements in modern Rules features include:

* **New engine**: New Rules features are powered by the [Ruleset Engine](https://developers.cloudflare.com/ruleset-engine/), which offers versatile configuration with a robust language that supports many HTTP request and response fields.
* **Improved scalability**: Thanks to the improved scalability, Cloudflare plans now have increased quotas.
* **Easier troubleshooting**: Rule execution is more predictable, since each rule operates independently, simplifying troubleshooting. Additionally, [Cloudflare Trace](https://developers.cloudflare.com/rules/trace-request/) helps understand rule interactions.
* **Improved consistency**: New Rules features also ensure consistency, with common fields and capabilities shared across products, offering a seamless experience and predictable Terraform configurations.

## Key differences

The evaluation and execution order of Rules features is different from Page Rules:

* **Rule matching logic**: Page Rules apply the first matching rule (first match wins). In contrast, modern Rules are stackable, meaning multiple matching rules can combine and apply to the same request (last match wins). For example, if multiple cache rules match the same URL, the features in those rules will all apply in order.
* **Action separation**: A Page Rule may include multiple actions for different products that are applied in a sequence selected by the customer within the Page Rule itself. Modern Rules features are evaluated [in a fixed sequence](https://developers.cloudflare.com/rules/origin-rules/#execution-order), with customers defining the rule order within a product [phase](https://developers.cloudflare.com/ruleset-engine/reference/phases-list/).
* **Precedence**: Modern Rules features take precedence over Page Rules. For instance, if both define caching settings for the same path, Cache Rules will override Page Rules.
* **Caching behavior**: In Cache Rules, selecting **Eligible for cache** automatically enables **Cache Everything** by default. To maintain the exact behavior of Page Rules, you may need to [adjust your configuration](https://developers.cloudflare.com/cache/how-to/cache-rules/page-rules-migration/).
* **Interactions with Workers**: Requests handled by Workers will suppress Page Rules actions, but they will not suppress actions from modern Rules features.

## Convert Page Rules URLs to filter expressions

Modern Rules use filter expressions instead of URL patterns. These expressions, built with the Rules language, allow greater precision by leveraging [fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/), [functions](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/), and [operators](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/).

The following example demonstrates the use of the [`http.request.full_uri`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.full_uri/) field and the `wildcard` operator for [wildcard matching](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/#wildcard-matching):

A **Page Rules URL** like:

`example.com/*/downloads/*.txt`

becomes a **filter expression** such as:

`http.request.full_uri wildcard "http*://example.com/*/downloads/*.txt*"`

[Single Redirects](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/create-dashboard/) and [URL Rewrite Rules](https://developers.cloudflare.com/rules/transform/url-rewrite/create-dashboard/) also offer a simplified view called **Wildcard pattern**, allowing you to specify URL patterns (`http*://example.com/*/downloads/*.txt*`) without specifying the full filter expression (`http.request.full_uri wildcard "http*://example.com/*/downloads/*.txt*"`).

### Important considerations

* **Protocol scheme**: Page Rules URL matching does not include the URI scheme (for example, `http://` or `https://`) unless explicitly included in the rule. Filter expressions using `http.request.full_uri` field, however, require matching the full URI, including the protocol scheme. To make your filter expression scheme-agnostic, use `http*://` as a wildcard for both `http://` and `https://`.
* **Query strings**: Page Rules ignore query strings unless they are part of the rule URL. Filter expressions include the query string automatically, as part of the `http.request.full_uri` field. To ensure query strings do not affect your matching, append a `*` wildcard at the end of your filter expression, such as `.txt*`.

## Feature correspondence table

To help you map existing Page Rules to modern Rules products, this table outlines how Page Rules settings translate to modern Rules and provides examples for common configurations.

Also, to streamline common configurations, the Cloudflare dashboard now includes dozens of one-click templates, available in **Rules** > **Overview**. These templates enable you to deploy commonly used features — such as redirects, rewrites, and header modifications — instantly, with pre-filled filter expressions and actions. Explore these templates in the dashboard for a faster setup.

| Page Rules setting | New implementation uses... | Migration/Replacement instructions |
| - | - | - |
| Always Use HTTPS | Redirect Rules (Single Redirects) | [Migrate Always Use HTTPS](#migrate-always-use-https) |
| Browser Cache TTL | Cache Rules | [Migrate Browser Cache TTL](#migrate-browser-cache-ttl) |
| Browser Integrity Check | Configuration Rules | [Migrate Browser Integrity Check](#migrate-browser-integrity-check) |
| Bypass Cache on Cookie | Cache Rules | [Migrate Bypass Cache on Cookie](#migrate-bypass-cache-on-cookie) |
| Cache By Device Type | Cache Rules | [Migrate Cache By Device Type](#migrate-cache-by-device-type) |
| Cache Deception Armor | Cache Rules | [Migrate Cache Deception Armor](#migrate-cache-deception-armor) |
| Cache Level | Cache Rules | [Migrate Cache Level](#migrate-cache-level-cache-everything) |
| Cache on Cookie | Cache Rules | [Migrate Cache on Cookie](#migrate-cache-on-cookie) |
| Cache TTL by status code | Cache Rules | [Migrate Cache TTL by status code](#migrate-cache-ttl-by-status-code) |
| Custom Cache Key | Cache Rules | [Migrate Custom Cache Key](#migrate-custom-cache-key) |
| Disable Apps | Configuration Rules | [Migrate Disable Apps](#migrate-disable-apps) |
| Disable Performance | N/A (deprecated) | [Replace Disable Performance](#replace-disable-performance) |
| Disable Railgun | N/A (deprecated) | N/A |
| Disable Security | N/A (deprecated) | [Replace Disable Security](#replace-disable-security) |
| Disable Zaraz | Configuration Rules | [Migrate Disable Zaraz](#migrate-disable-zaraz) |
| Edge Cache TTL | Cache Rules | [Migrate Edge Cache TTL](#migrate-edge-cache-ttl) |
| Email Obfuscation | Configuration Rules | [Migrate Email Obfuscation](#migrate-email-obfuscation) |
| Forwarding URL | Redirect Rules (Single Redirects) | [Migrate Forwarding URL](#migrate-forwarding-url) |
| Host Header Override | Origin Rules | [Migrate Host Header Override](#migrate-host-header-override) |
| IP Geolocation Header | Transform Rules (Managed Transforms) | [Migrate IP Geolocation Header](#migrate-ip-geolocation-header) |
| Mirage (deprecated) | Configuration Rules | [Migrate Mirage](#migrate-mirage) |
| Opportunistic Encryption | Configuration Rules | [Migrate Opportunistic Encryption](#migrate-opportunistic-encryption) |
| Origin Cache Control | Cache Rules | [Migrate Origin Cache Control](#migrate-origin-cache-control) |
| Origin Error Page Pass-thru | Cache Rules | [Migrate Origin Error Page Pass-thru](#migrate-origin-error-page-pass-thru) |
| Polish | Configuration Rules | [Migrate Polish](#migrate-polish) |
| Query String Sort | Cache Rules | [Migrate Query String Sort](#migrate-query-string-sort) |
| Resolve Override | Origin Rules | [Migrate Resolve Override](#migrate-resolve-override) |
| Respect Strong ETags | Cache Rules | [Migrate Respect Strong ETags](#migrate-respect-strong-etags) |
| Response Buffering | N/A (deprecated) | N/A |
| Rocket Loader | Configuration Rules | [Migrate Rocket Loader](#migrate-rocket-loader) |
| Security Level | Configuration Rules | [Migrate Security Level](#migrate-security-level) |
| True Client IP Header | Transform Rules (Managed Transforms) | [Migrate True Client IP Header](#migrate-true-client-ip-header) |
| SSL | Configuration Rules | [Migrate SSL](#migrate-ssl) |
| Web Application Firewall | N/A (deprecated) | N/A |

### Migrate Always Use HTTPS

* Dashboard

  **Context:**

  You configured a Page Rule to perform an automatic redirect from HTTP to HTTPS for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL** `*example.com/*`
  * **Setting**: *Always Use HTTPS*

  **How to migrate**:

  1. [Create a single redirect](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/create-dashboard/) to always redirect HTTP requests to HTTPS. You can select the **Redirect from HTTP to HTTPS** rule template or enter the following rule configuration:

     * **If incoming requests match**: Wildcard pattern
       * **Request URL**: `http://*`

     * **Then**:

       * **Target URL**: `https://${1}`
       * **Status code**: *301*
       * **Preserve query string**: Enabled

  2. Turn off your existing Page Rule and validate the behavior of the redirect you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a single redirect |
  | - | - |
  | ![Example Page Rule with 'Always Use HTTPS' setting](https://developers.cloudflare.com/_astro/pr-always-use-https.CUl_pNfb_ZgNVzQ.webp) | ![Single redirect matching the 'Always Use HTTPS' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-always-use-https-new.BOryxIv0_Z1PXopK.webp) |

### Migrate Automatic HTTPS Rewrites

* Dashboard

  **Context:**

  You configured a Page Rule turning on Automatic HTTPS Rewrites for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Automatic HTTPS Rewrites*
  * **Value**: On

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to always rewrite HTTP links to HTTPS for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:

       * **Setting**: Automatic HTTPS Rewrites
       * **Value**: On

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Automatic HTTPS Rewrites' setting](https://developers.cloudflare.com/_astro/pr-automatic-https-rewrites.CLJyVtYV_16kmu8.webp) | ![Configuration rule matching the 'Automatic HTTPS Rewrites' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-automatic-https-rewrites-new.Bkd1FpXw_Z1ystiY.webp) |

### Migrate Browser Cache TTL

* Dashboard

  **Context:**

  You configured a Page Rule adjusting browser cache TTL to one day for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Browser Cache TTL*
  * **Enter Browser Cache TTL**: *a day*

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to adjust browser cache TTL for caching resources in the browser to one day for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Browser TTL**: Override origin and use this TTL
       * **Input time-to-live (TTL)**: *1 day*

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Browser Cache TTL' setting](https://developers.cloudflare.com/_astro/pr-browser-cache-ttl.BsUhcEXO_1F769k.webp) | ![Cache rule matching the 'Browser Cache TTL' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-browser-cache-ttl-new.CFYgSIfM_Z4vWT2.webp) |

### Migrate Browser Integrity Check

* Dashboard

  **Context:**

  You configured a Page Rule turning on Browser Integrity Check for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Browser Integrity Check*
  * **Value**: On

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn on Browser Integrity Check for protecting against bots and threats for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:

       * **Setting**: Browser Integrity Check
       * **Value**: On

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Browser Integrity Check' setting](https://developers.cloudflare.com/_astro/pr-browser-integrity-check.0TsdxTXD_1JWmeD.webp) | ![Configuration rule matching the 'Browser Integrity Check' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-browser-integrity-check-new.DABehTnG_1IIURY.webp) |

### Migrate Bypass Cache on Cookie

* Dashboard

  **Context:**

  You configured a Page Rule turning on Bypass Cache on Cookie for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Bypass Cache on Cookie*
  * **Enter value**: `test_cookie`

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to bypass cache for requests containing cookie `test_cookie` for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com" AND Cookie contains "test-cookie"`
       * Using the Expression Editor:\
         `(http.host contains "example.com" and http.cookie contains "test-cookie")`

     * **Then**:
       * **Cache eligibility**: Bypass cache

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Bypass Cache on Cookie' setting](https://developers.cloudflare.com/_astro/pr-bypass-cache-on-cookie.h4Mq0pkO_21nXKe.webp) | ![Cache rule matching the 'Bypass Cache on Cookie' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-bypass-cache-on-cookie-new.BeJb7-Bu_2pBuYI.webp) |

### Migrate Cache By Device Type

* Dashboard

  **Context:**

  You configured a Page Rule turning on Cache By Device Type for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Cache By Device Type*
  * **Value**: On

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to cache content based on user agent or device type for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Setting**: Cache key
         * **Cache by device type**: On

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Cache By Device Type' setting](https://developers.cloudflare.com/_astro/pr-cache-by-device-type.D_TlBAdc_Z1tXrQI.webp) | ![Cache rule matching the 'Cache By Device Type' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-cache-by-device-type-new.j6a5kEn__ZNQIPx.webp) |

### Migrate Cache Deception Armor

* Dashboard

  **Context:**

  You configured a Page Rule turning on Cache Deception Armor for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: Cache Deception Armor

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to protect against cache deception attacks for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Setting**: Cache key
         * **Cache deception armor**: On

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Cache Deception Armor' setting](https://developers.cloudflare.com/_astro/pr-cache-deception-armor.CAh-wrs4_Z1y7Xtq.webp) | ![Cache rule matching the 'Cache Deception Armor' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-cache-deception-armor-new.BT9l5EUw_Z21H50k.webp) |

### Migrate Cache Level (Cache Everything)

* Dashboard

  **Context:**

  You configured a Page Rule turning on caching of all assets for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Cache Level*
  * **Select Cache Level**: *Cache Everything*

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to adjust cache level for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:
       * **Cache eligibility**: Eligible for cache

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Cache Level' set to 'Cache Everything'](https://developers.cloudflare.com/_astro/pr-cache-level-everything.DdVHSP6R_10sQCU.webp) | ![Cache rule matching the 'Cache Level: Cache Everything' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-cache-level-everything-new.CWHQUlgp_2ejSU5.webp) |

### Migrate Cache on Cookie

* Dashboard

  **Context:**

  You configured a Page Rule turning on caching for responses that contained cookie `test-cookie` for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Cache on Cookie*
  * **Enter value**: `test-cookie`

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to cache responses containing cookie `test_cookie` for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com" AND Cookie contains "test-cookie"`
       * Using the Expression Editor:\
         `(http.host contains "example.com" and http.cookie contains "test-cookie")`

     * **Then**:
       * **Cache eligibility**: Eligible for cache

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Cache on Cookie' setting](https://developers.cloudflare.com/_astro/pr-cache-on-cookie.ByvIqgIj_Z1sNNc8.webp) | ![Cache rule matching the 'Cache on Cookie' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-cache-on-cookie-new.PWLmyHmb_Z1tlA4i.webp) |

### Migrate Cache TTL by status code

* Dashboard

  **Context:**

  You configured a Page Rule turning on caching of every response with status code between `200` and `599` for one day, for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Cache TTL by status code*
  * **Status code or enter range**: `200-599`
  * **Select option**: *a day*

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to cache responses with status code between `200` and `599` for one day for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`

       * Using the Expression Editor:\
         `(http.host contains "example.com")`

       * **Then**:

         * **Cache eligibility**: Eligible for cache

         * **Setting**: Edge TTL

           * Use cache-control header if present, use default Cloudflare caching behavior if not

           * **Status code TTL**:

             * **Scope**: *Range*
             * **From**: *200*
             * **To**: *599*
             * **Duration**: *1 day*

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with the 'Cache TTL by status code' setting](https://developers.cloudflare.com/_astro/pr-cache-ttl-by-status-code.BEFPIQlk_Z1AMyjN.webp) | ![Cache rule matching the 'Cache TTL by status code' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-cache-ttl-by-status-code-new.D7fRKD4K_1XqnnT.webp) |

### Migrate Custom Cache Key

* Dashboard

  **Context:**

  You configured a Page Rule setting a custom cache key for all query string parameters, for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Custom Cache Key*
    * **Query String**: All query string parameters

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to set a custom cache key for all query string parameters, for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Setting**: Cache key
         * **Query string**: All query string parameters

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with the 'Custom Cache Key' setting](https://developers.cloudflare.com/_astro/pr-custom-cache-key.B4mIYhPL_Z1mAxa6.webp) | ![Cache rule matching the 'Custom Cache Key' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-custom-cache-key-new.Cgx92M0b_ZzTcjR.webp) |

### Migrate Disable Apps

* Dashboard

  **Context:**

  You configured a Page Rule turning off Cloudflare Apps (deprecated) for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Disable Apps*

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to disable Cloudflare Apps (deprecated) for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Disable Apps

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Disable Apps' setting](https://developers.cloudflare.com/_astro/pr-disable-apps.DtWuKgu3_Z1dKx7E.webp) | ![Configuration rule matching the 'Disable Apps' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-disable-apps-new.D0ZGFzGR_Zrxgvi.webp) |

### Replace Disable Performance

Warning

The **Disable Performance** setting is deprecated. Any Page Rules with this setting will not be migrated.

This Page Rules setting turned off Mirage (deprecated), Polish, and Rocket Loader. You can still turn on or off relevant Cloudflare features one by one using Configuration Rules.

* Dashboard

  **Context:**

  You configured a Page Rule with **Disable Performance** (deprecated) for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Disable Performance*

  **How to replace**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to disable Mirage, Polish, and Rocket Loader for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:

       * **Mirage**: Off
       * **Polish**: *Off*
       * **Rocket Loader**: Off

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Disable Performance' setting](https://developers.cloudflare.com/_astro/pr-disable-performance.Q-fOmuUU_60ytE.webp) | ![Configuration rule partially matching the 'Disable Performance' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-disable-performance-new.DL9beJ7__ZdPHK.webp) |

### Replace Disable Security

Warning

The **Disable Security** setting is deprecated. Any Page Rules with this setting will not be migrated.

This Page Rules setting turns off Email Obfuscation, Rate Limiting (previous version), Scrape Shield, URL (Zone) Lockdown, and WAF managed rules (previous version). You can still turn on or off relevant Cloudflare features one by one using Configuration Rules and WAF custom rules.

* Dashboard

  **Context:**

  You configured a Page Rule with **Disable Security** (deprecated) for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Disable Security*

  This setting turned off a subset of Cloudflare security features: Email Obfuscation, Rate Limiting (previous version), Scrape Shield, URL (Zone) Lockdown, and WAF managed rules (previous version).

  **How to replace**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn off one or more security features:

     * Email Obfuscation (part of [Cloudflare Scrape Shield](https://developers.cloudflare.com/waf/tools/scrape-shield/))
     * Hotlink Protection (part of Cloudflare Scrape Shield)

  2. If required, [create a WAF exception](https://developers.cloudflare.com/waf/managed-rules/waf-exceptions/define-dashboard/) to skip one or more rules of WAF managed rulesets for requests coming from IP addresses in an allowlist.

  3. Turn off your existing Page Rule and validate the behavior of the rules you created.

  4. If your tests succeed, delete the existing Page Rule.

  Warning

  If you are still using [WAF managed rules (previous version)](https://developers.cloudflare.com/waf/reference/legacy/old-waf-managed-rules/) or [Rate Limiting (previous version)](https://developers.cloudflare.com/waf/reference/legacy/old-rate-limiting/), consider upgrading to the new versions of these products. It is not possible to turn off these older products using modern Rules features.

### Migrate Disable Zaraz

* Dashboard

  **Context:**

  You configured a Page Rule turning off [Zaraz](https://developers.cloudflare.com/zaraz/) for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Disable Zaraz*

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn off Zaraz for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Disable Zaraz

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Disable Zaraz' setting](https://developers.cloudflare.com/_astro/pr-disable-zaraz.BO7qA0TE_ZnsgKi.webp) | ![Configuration rule matching the 'Disable Zaraz' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-disable-zaraz-new.Cc92OsIN_Z6Ica7.webp) |

### Migrate Edge Cache TTL

* Dashboard

  **Context:**

  You configured a Page Rule adjusting Edge Cache TTL for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Edge Cache TTL*
  * **Enter Edge Cache TTL**: *a day*

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to adjust edge cache TTL for caching resources on Cloudflare edge to one day, for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache

       * **Setting**: Edge TTL

         * Ignore cache-control header and use this TTL
         * **Input time-to-live (TTL)**: *1 day*

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with the 'Edge Cache TTL' setting](https://developers.cloudflare.com/_astro/pr-edge-cache-ttl.DdpuJjjM_Z1WW60v.webp) | ![Cache rule matching the 'Edge Cache TTL' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-edge-cache-ttl-new.CASDurRT_2oX2AI.webp) |

### Migrate Email Obfuscation

* Dashboard

  **Context:**

  You configured a Page Rule turning off [Email Obfuscation](https://developers.cloudflare.com/waf/tools/scrape-shield/email-address-obfuscation/) for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Email Obfuscation*
  * **Value**: Off

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn off Email Obfuscation for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Email Obfuscation
         * **Value**: Off

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Email Obfuscation' setting](https://developers.cloudflare.com/_astro/pr-email-obfuscation.B5bsi7dl_2nDP9z.webp) | ![Configuration rule matching the 'Email Obfuscation > Off' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-email-obfuscation-new.CV0JNmIj_Z12WwPn.webp) |

### Migrate Forwarding URL

**Example #1: Redirect `www` to root domain**

* Dashboard

  **Context:**

  You configured a Page Rule permanently redirecting `www.example.com` to `example.com` on all URI paths:

  * **URL**: `www.example.com/*`
  * **Setting**: *Forwarding URL*
  * **Select Status code**: *301 - Permanent Redirect*
  * **Destination URL**: `https://example.com/$1`

  **How to migrate**:

  1. [Create a single redirect](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/create-dashboard/) to permanently redirect requests from `https://www.example.com` to `https://example.com`. You can select the **Redirect from WWW to Root** rule template or enter the following rule configuration:

     * **If incoming requests match**: Wildcard pattern
       * **Request URL**: `https://www.example.com/*`

     * **Then**:

       * **Target URL**: `https://example.com/${1}`
       * **Status code**: *301*
       * **Preserve query string**: Enabled

  2. Turn off your existing Page Rule and validate the behavior of the redirect you created.

  3. If your tests succeed, delete the existing Page Rule.

  Notes about the rule equivalence

  The provided example using Single Redirects is not an exact match for the previously existing Page Rule in the same example.

  The exact equivalent would need to match both HTTP and HTTPS incoming requests, which you could achieve using a wildcard pattern like the following (notice the extra `*` after `http`):

  * **Request URL**: `http*://www.example.com/*`

  This would require you to also change the **Target URL** to use the second wildcard capture group instead of the first one (corresponding to the text captured by second `*` in the wildcard pattern above):

  * **Target URL**: `https://example.com/${2}`

* Visual guide

  | Page Rules configuration | Migrate to a single redirect |
  | - | - |
  | ![Example Page Rule #1 with 'Forwarding URL' setting](https://developers.cloudflare.com/_astro/pr-forwarding-url.DyV2zs8N_Z7hQWe.webp) | ![Single redirect matching the 'Forwarding URL' setting of the example Page Rule #1](https://developers.cloudflare.com/_astro/pr-forwarding-url-new.FfZIMpof_1up4Y2.webp) |

**Example #2: Redirect all pages under old path to new path**

* Dashboard

  **Context:**

  You configured a Page Rule permanently redirecting `example.com/old-path` to `example.com/new-path`:

  * **URL**: `example.com/old-path/*`
  * **Setting**: *Forwarding URL*
  * **Select Status code**: *301 - Permanent Redirect*
  * **Destination URL**: `https://example.com/new-path/$1`

  **How to migrate**:

  1. [Create a single redirect](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/create-dashboard/) to permanently redirect requests for `example.com/old-path` to `example.com/new-path`:

     * **If incoming requests match**: Wildcard pattern
       * **Request URL**: `https://example.com/old-path/*`

     * **Then**:

       * **Target URL**: `https://example.com/new-path/${1}`
       * **Status code**: *301*
       * **Preserve query string**: Enabled

  2. Turn off your existing Page Rule and validate the behavior of the redirect you created.

  3. If your tests succeed, delete the existing Page Rule.

  Notes about the rule equivalence

  The provided example using Single Redirects is not an exact match for the previously existing Page Rule in the same example.

  The exact equivalent would need to match both HTTP and HTTPS incoming requests, which you could achieve using a wildcard pattern like the following (notice the extra `*` after `http`):

  * **Request URL**: `http*://example.com/old-path/*`

  This would require you to also change the **Target URL** to use the second wildcard capture group instead of the first one (corresponding to the text captured by second `*` in the wildcard pattern above):

  * **Target URL**: `https://example.com/new-path/${2}`

* Visual guide

  | Page Rules configuration | Migrate to a single redirect |
  | - | - |
  | ![Example Page Rule #2 with 'Forwarding URL' setting](https://developers.cloudflare.com/_astro/pr-forwarding-url-2.CNt6YZ_U_ZubTyR.webp) | ![Single redirect matching the 'Forwarding URL' setting of the example Page Rule #2](https://developers.cloudflare.com/_astro/pr-forwarding-url-2-new.CP3zl46U_Z1dDz5U.webp) |

### Migrate Host Header Override

* Dashboard

  **Context:**

  You configured a Page Rule changing the `Host` HTTP header to `example.saas-provider.com`, for all requests addressed at any subdomain of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Host Header Override*
  * **Enter value**: `example.saas-provider.com`

  **How to migrate**:

  1. [Create an origin rule](https://developers.cloudflare.com/rules/origin-rules/create-dashboard/) changing the `Host` header to `example.saas-provider.com` for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:
       * **Set origin parameters**:
         * **Host Header** > **Rewrite to**: `example.saas-provider.com`

  2. Turn off your existing Page Rule and validate the behavior of the origin rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to an origin rule |
  | - | - |
  | ![Example Page Rule with 'Host Header Override' setting](https://developers.cloudflare.com/_astro/pr-host-header-override.BXq8XNIs_ZxEPQ9.webp) | ![Origin rule matching the 'Host Header Override' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-host-header-override-new.DUASGBHN_1FgVbV.webp) |

### Migrate IP Geolocation Header

* Dashboard

  **Context:**

  You configured a Page Rule adding a `CF-IPCountry` HTTP header, for all requests addressed at any subdomain of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *IP Geolocation Header*
  * **Value**: On

  **How to migrate**:

  1. [Turn on the **Add visitor location headers** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/) — a Transform Rules feature — to add the `CF-IPCountry` and other location headers to all requests.
  2. Turn off your existing Page Rule and validate the behavior of the Managed Transform.
  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a Managed Transform |
  | - | - |
  | ![Example Page Rule with 'IP Geolocation Header' setting](https://developers.cloudflare.com/_astro/pr-ip-geolocation-header._es904nB_2lU1sj.webp) | ![The 'Add visitor location headers' Managed Transform matching the 'IP Geolocation Header' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-ip-geolocation-header-new.D3CE9V7z_HdV93.webp) |

### Migrate Mirage (deprecated)

* Dashboard

  **Context:**

  You configured a Page Rule turning off Mirage (deprecated) for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Mirage*
  * **Value**: Off

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn off Mirage for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Mirage
         * **Value**: Off

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Mirage' setting](https://developers.cloudflare.com/_astro/pr-mirage.pHLFHQcL_Z1pN423.webp) | ![Configuration rule matching the 'Mirage > Off' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-mirage-new.BZKE-odE_Z173H4m.webp) |

### Migrate Opportunistic Encryption

* Dashboard

  **Context:**

  You configured a Page Rule turning off Opportunistic Encryption for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Opportunistic Encryption*
  * **Value**: Off

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn off Opportunistic Encryption for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Opportunistic Encryption
         * **Value**: Off

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Opportunistic Encryption' setting](https://developers.cloudflare.com/_astro/pr-opportunistic-encryption.BcbwaI0m_yewVK.webp) | ![Configuration rule matching the 'Opportunistic Encryption > Off' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-opportunistic-encryption-new.LwpNCqst_fUfYN.webp) |

### Migrate Origin Cache Control

* Dashboard

  **Context:**

  You configured a Page Rule turning off Origin Cache Control for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: Origin Cache Control
  * **Value**: Off

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to determine edge cache behavior for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Setting**: Origin Cache Control
         * **Enable Origin Cache Control**: Off

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Origin Cache Control' setting](https://developers.cloudflare.com/_astro/pr-origin-cache-control.DCUWJE-U_ZyIMHF.webp) | ![Cache rule matching the 'Origin Cache Control' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-origin-cache-control-new.DqpXz-FD_Z1MqoB7.webp) |

### Migrate Origin Error Page Pass-thru

* Dashboard

  **Context:**

  You configured a Page Rule turning on Origin Error Page Pass-thru for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Origin Error Page Pass-thru*
  * **Value**: On

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to determine edge cache behavior for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Setting**: Origin error page pass-thru
         * **Use Origin error page pass-thru**: On

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Origin Error Page Pass-thru' setting](https://developers.cloudflare.com/_astro/pr-origin-error-page-pass-thru.CaO5dguv_1PhVzz.webp) | ![Cache rule matching the 'Origin Error Page Pass-thru > On' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-origin-error-page-pass-thru-new.CEumhpfw_ZPudFP.webp) |

### Migrate Polish

* Dashboard

  **Context:**

  You configured a Page Rule turning off [Polish](https://developers.cloudflare.com/images/polish/) for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: Polish
  * **Value**: Off

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn off Polish for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Polish
         * **Select value**: *Off*

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Polish' setting](https://developers.cloudflare.com/_astro/pr-polish.BMjezHuI_Z148pI0.webp) | ![Configuration rule matching the 'Polish > Off' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-polish-new.BPVnKGv2_1Xo8d2.webp) |

### Migrate Query String Sort

* Dashboard

  **Context:**

  You configured a Page Rule turning on Query String Sort for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Query String Sort*
  * **Value**: On

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to sort query string parameters for caching purposes, for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Setting**: Cache key
         * **Sort query string**: On

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Query String Sort' setting](https://developers.cloudflare.com/_astro/pr-query-string-sort.C01G9KtA_1coNfp.webp) | ![Cache rule matching the 'Query String Sort > On' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-query-string-sort-new.DhEB-zV8_1Yj0V4.webp) |

### Migrate Resolve Override

* Dashboard

  **Context:**

  You configured a Page Rule changing the origin to `example.saas-provider.com`, for all requests addressed at any subdomain of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Resolve Override*
  * **Enter value**: `example.saas-provider.com`

  **How to migrate**:

  1. [Create an origin rule](https://developers.cloudflare.com/rules/origin-rules/create-dashboard/) overriding the origin to `example.saas-provider.com` for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:
       * **DNS Record** > **Override to**: `example.saas-provider.com`

  2. Turn off your existing Page Rule and validate the behavior of the origin rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to an origin rule |
  | - | - |
  | ![Example Page Rule with 'Resolve Override' setting](https://developers.cloudflare.com/_astro/pr-resolve-override.B4LoxPLL_1MfH2O.webp) | ![Origin rule matching the 'Resolve Override' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-resolve-override-new.CqsoTaU3_Z2x2PsM.webp) |

### Migrate Respect Strong ETags

* Dashboard

  **Context:**

  You configured a Page Rule turning on byte-for-byte equivalency checks for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Respect Strong ETags*
  * **Value**: On

  **How to migrate**:

  1. [Create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/) to respect strong ETags for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then**:

       * **Cache eligibility**: Eligible for cache
       * **Setting**: Respect strong ETags
         * **Use strong ETag headers**: On

     Warning

     The default behavior of Cache Rules is different from Page Rules. Refer to [Key differences](#key-differences) for more information.

  2. Turn off your existing Page Rule and validate the behavior of the cache rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a cache rule |
  | - | - |
  | ![Example Page Rule with 'Respect Strong ETags' setting](https://developers.cloudflare.com/_astro/pr-respect-strong-etags.CUOv_EvP_1Gynxg.webp) | ![Cache rule matching the 'Respect Strong ETags > On' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-respect-strong-etags-new.BnNZFkL6_2wK2y8.webp) |

### Migrate Rocket Loader

* Dashboard

  **Context:**

  You configured a Page Rule turning off Rocket Loader for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Rocket Loader*
  * **Value**: Off

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to turn off Rocket Loader for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Rocket Loader
         * **Value**: Off

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Rocket Loader' setting](https://developers.cloudflare.com/_astro/pr-rocket-loader.DOfWWA3Z_Z1VrtJp.webp) | ![Configuration rule matching the 'Rocket Loader > Off' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-rocket-loader-new.CPlD3EdY_SNzWs.webp) |

### Migrate Security Level

* Dashboard

  **Context:**

  You configured a Page Rule setting Security Level to *I'm Under Attack* for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *Security Level*
  * **Select Security Level**: *I'm Under Attack*

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to set Security Level to *I'm Under Attack*, for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: Security Level
         * **Select Security Level**: *I'm Under Attack*

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'Security Level' setting](https://developers.cloudflare.com/_astro/pr-security-level.YzQR-68G_wL4dy.webp) | ![Configuration rule matching the "Security Level > I'm Under Attack" setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-security-level-new.DA7cdMhw_Z1yFT1G.webp) |

### Migrate True Client IP Header

* Dashboard

  **Context:**

  You configured a Page Rule adding a `True-Client-IP` HTTP header for all requests addressed at any subdomain of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *True Client IP Header*
  * **Value**: On

  **How to migrate**:

  1. [Turn on the **Add "True-Client-IP" header** Managed Transform](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/) — a Transform Rules feature — to add the `True-Client-IP` header to all requests.
  2. Turn off your existing Page Rule and validate the behavior of the Managed Transform.
  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a Managed Transform |
  | - | - |
  | ![Example Page Rule with 'True Client IP Header' setting](https://developers.cloudflare.com/_astro/pr-true-client-ip-header.h51QIhp7_Z1foMhl.webp) | ![The 'Add "True-Client-IP" header' Managed Transform matching the 'True Client IP Header' setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-true-client-ip-header-new.DKFw6CYO_QgNqw.webp) |

### Migrate SSL

* Dashboard

  **Context:**

  You configured a Page Rule setting SSL to *Strict* for all subdomains of `example.com` and the `example.com` domain itself:

  * **URL**: `*example.com/*`
  * **Setting**: *SSL*
  * **Select SSL/TLS encryption mode**: *Strict*

  **How to migrate**:

  1. [Create a configuration rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/) to set SSL to *Strict*, for any hostname containing `example.com`:

     * **When incoming requests match**: Custom filter expression

       * Using the Expression Builder:\
         `Hostname contains "example.com"`
       * Using the Expression Editor:\
         `(http.host contains "example.com")`

     * **Then the settings are**:
       * **Setting**: SSL
         * **Select SSL/TLS encryption mode**: *Strict*

  2. Turn off your existing Page Rule and validate the behavior of the configuration rule you created.

  3. If your tests succeed, delete the existing Page Rule.

* Visual guide

  | Page Rules configuration | Migrate to a configuration rule |
  | - | - |
  | ![Example Page Rule with 'SSL' setting](https://developers.cloudflare.com/_astro/pr-ssl.pGEGjIS-_injL4.webp) | ![Configuration rule matching the "SSL" setting of the example Page Rule](https://developers.cloudflare.com/_astro/pr-ssl-new.DjFLYHwZ_Z1yCkLw.webp) |

## Settings that will not be migrated

The following Page Rules settings will not be migrated to other types of rules:

* **Disable Performance** (this setting is deprecated)
* **Disable Railgun** (this setting is deprecated, since Railgun is no longer available)
* **Disable Security** (this setting is deprecated)
* **Response Buffering** (this setting is deprecated)
* **Web Application Firewall** (this setting is deprecated, since the previous version of WAF managed rules is deprecated)

All other Page Rules settings will be migrated during 2025.

## More resources

If you have feedback to share, refer to our [Community thread](https://community.cloudflare.com/t/important-page-rules-deprecation/656021).
