---
title: FAQ · Cloudflare Log Explorer docs
description: Find answers to common questions about Log Explorer.
lastUpdated: 2025-10-09T09:19:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/log-explorer/faq/
  md: https://developers.cloudflare.com/log-explorer/faq/index.md
---

## Which fields (or columns) are available for querying?

All fields listed in [Datasets](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/) for the [supported datasets](https://developers.cloudflare.com/log-explorer/manage-datasets/#supported-datasets) are viewable in Log Explorer.

## Why does my query not complete or time out?

Log Explorer performs best when query parameters focus on narrower ranges of time. You may experience query timeouts when your query would return a large quantity of data. Consider refining your query to improve performance.

## Why do I not see any logs in my queries after enabling the dataset?

Log Explorer starts ingesting logs from the moment you enable the dataset. It will not display logs for events that occurred before the dataset was enabled. Make sure that new events have been generated since enabling the dataset, and check again.

## My query returned an error. How do I figure out what went wrong?

We are actively working on improving error codes. If you receive a generic error, check your SQL syntax (if you are using the custom SQL feature), and make sure you have included a date and a limit. If the query still fails it is likely timing out. Try refining your filters.

## Where is the data stored?

The data is stored in Cloudflare R2. Each Log Explorer dataset is stored on a per-customer level, similar to Cloudflare D1, ensuring that your data is kept separate from that of other customers. In the future, this single-tenant storage model will provide you with the flexibility to create your own retention policies and decide in which regions you want to store your data.

## Does Log Explorer support Customer Metadata Boundary?

Customer Metadata Boundary is currently not supported for Log Explorer.

## Are there any constraints on the log volume that Log Explorer can support?

We are continually scaling the Log Explorer data platform. At present, Log Explorer supports log ingestion rates of up to 50,000 records per second. If your needs exceed this, contact your account team.

## How is Log Explorer different from Logpush? Do I need both?

Log Explorer allows you to search and analyze your Cloudflare logs directly in the dashboard or via API. [Logpush](https://developers.cloudflare.com/logs/logpush/), on the other hand, delivers raw logs to third-party SIEMs or storage systems. You generally do not need both, but some customers choose to use Log Explorer for quick investigation and Logpush for long-term storage or integration with other tools.

## Is there a free version or trial of Log Explorer?

Log Explorer is available as a paid add-on for any Application Services or Zero Trust purchase. There is no free version at this time.

## How is Log Explorer billed?

Log Explorer billing is based on the volume of logs indexed and stored, measured in gigabytes (GB). Your charges scale with the amount of log data you choose to retain in Log Explorer. Unlike query-based billing models (for example, BigQuery), charges are not based on how often you search or scan your data. Once logs are ingested and stored, you can query them without additional cost.

## Are logs from attack traffic included in my Log Explorer usage?

Yes. In general, Log Explorer bills based on the total volume of logs ingested and stored, including attack traffic. Since these logs are often critical for investigating security incidents, they are treated the same as all other log data.

However, logs generated from Layer 7 (L7) DDoS attack traffic are not ingested by default and therefore do not count toward your Log Explorer usage.

## How does Log Explorer store data in R2, and why do I not see it in my own R2 bucket?

Log Explorer uses Cloudflare Logpush and R2 behind the scenes to stream and store logs. For technical and performance reasons, the data is stored in internal, customer-specific R2 buckets managed by Cloudflare. These buckets are single-tenant to keep your data isolated, but they are not visible in your account's R2 interface. You are not billed separately for this storage — it is included in your Log Explorer usage.

## Are Custom Dashboards based on R2 Log Explorer data, or on GraphQL?

Custom Dashboards currently run on [GraphQL](https://developers.cloudflare.com/analytics/graphql-api/sampling/). Over time, this will evolve to include deeper integration between the two features, such as building charts directly from logs.

## How can I track my Log Explorer usage?

Your monthly usage is displayed at the top of the Log Search and Manage Datasets dashboard sections within Log Explorer.

![Usage display in the dashboard](https://developers.cloudflare.com/_astro/log-explorer-usage.CTcGXtWV_19FbL3.webp)

## How do I turn off Log Explorer?

Use the Manage Datasets feature to enable or disable ingestion for individual datasets and zones.

1. In the Cloudflare dashboard, go to the **Manage Account** > **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Under **Subscriptions**, find the Log Explorer subscription, and select **Cancel**.
