---
title: DocuSign · Cloudflare One docs
description: This guide covers how to configure Docusign as a SAML application
  in Cloudflare One.
lastUpdated: 2025-10-27T15:01:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/docusign-access/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/docusign-access/index.md
---

This guide covers how to configure [Docusign](https://support.docusign.com/s/document-item?bundleId=rrf1583359212854\&topicId=ozd1583359139126.html) as a SAML application in Cloudflare One.

## Prerequisites

* An [identity provider](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) configured in Cloudflare One
* Admin access to a Docusign account that has Single Sign-On available
* A [domain](https://support.docusign.com/s/document-item?bundleId=rrf1583359212854\&topicId=gso1583359141256.html) verified in Docusign

## 1. Create the Access for SaaS application

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Access controls** > **Applications**.

2. Select **Add an Application**.

3. Select **SaaS**.

4. Use the following configuration:

   * Set the **Application** to *DocuSign*.
   * Put placeholder values in **EntityID** and **Assertion Consumer Service URL** (for example, `https://example.com`). We'll come back and update these.
   * Set **Name ID Format** to: *Unique ID*.

5. DocuSign requires SAML attributes to do Just In Time user provisioning. Ensure you are collecting SAML attributes from your IdP:

   * Group
   * username
   * department
   * firstName
   * lastName
   * phone

6. These IdP SAML values can then be mapped to the following DocuSign SAML attributes:

   * Email
   * Surname
   * Givenname

7. Set an Access policy (for example, create a policy based on *Emails ending in @example.com*).

8. Copy and save the **SSO Endpoint**, **Entity ID** and **Public Key**.

9. Transform the **Public Key** into a fingerprint:

   1. Copy the **Public Key** Value.

   2. Paste the **Public Key** into VIM or another code editor.

   3. Wrap the value in `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`.

   4. Set the file extension to `.crt` and save.

## 2. Configure your DocuSign SSO instance

1. Ensure you have a domain claimed in DocuSign.

2. From the DocuSign Admin dashboard, select **Identity Providers**.

3. On the Identity Providers page, select **ADD IDENTITY PROVIDER**. Use the following mappings from the saved Access Application values:

   * **Name**: Pick your desired name.
   * **Identity Provider Issuer**: Entity ID.
   * **Identity Provider Login URL**: Assertion Consumer Service URL.

4. Save the Identity Provider.

5. Upload your certificate to the *DocuSign Identity Provider* menu.

6. Configure your SAML Attribute mappings. The Attribute Names should match the values in **IdP Value** in your Access application.

7. Go back to the Identity Provider's screen and select **Actions** > **Endpoints**. Copy and save the following:

   * Service Provider Issuer URL.
   * Service Provider Assertion Consumer Service URL.

## 3. Finalize your Cloudflare configuration

1. Go back to your DocuSign application under **Access** > **Applications**.

2. Select **Edit**.

3. Use the following mappings:

   * EntityID->Service Provider Issuer URL.
   * Assertion Consumer Service URL -> Service Provider Assertion Consumer Service URL.

4. Save the application.

When ready, enable the SSO for your DocuSign account and you will be able to login to DocuSign via Cloudflare SSO and your Identity Provider.
